


 /***************************************************************************************************************
  *                                                                                                             *
  *                        Example_2. ET-REMOTE MP3 Trig-Mode By Check EOF Signal                               *
  *                                                                                                             *
  ***************************************************************************************************************
  *																					                            *
  *  Target MCU    : LPC2138 (CP-JRARM7 LPC2138)                                                                *
  *       	       : X-TAL : 19.6608 MHz                                                                        * 
  *                : PLL Setup = M(3),P(2)	                                                                    *
  *                : Run Speed 58.9824 MHz(With PLL)(19.6608MHz x 3 = 58.9824 MHz                               *         
  *                : VPB Clock(pclk) = CPU Clock/2 = 58.9824MHz/2 = 29.4912 MHz                                 *
  *                : CPU Clock(cclk) = 58.9824 MHz                                                              *           
  *                                                                                                             *
  * Editor         : uVision3 (V3.60)                                                                           *
  * Compiler       : RealView MDK-ARM 3.20        															    *
  * Port Interface :                                                                                            *
  *																											    *
  *            I/O : # MCU-ARM7 LPC2138 #            # ET-REMOTE MP3 #                                          *
  *                  --------------------           -----------------                                           *
  *                                                                                                             *                                   
  *                  P0[16..23](OUT)      connect       Trig CH1-CH8                                            *                                        
  *                  P1[16..23](OUT)      connect       Trig CH9-CH16                                           *  
  *                  P0.31(IN)            connect       EOF Terminal                        				    *
  *                  GND                  connect       GND                                                     *                                                           
  *                                                                                                    		    *
  *                                                                                  -DIP-SW.MODE               *
  *                 3.3V                                                              S1=OFF,S2=OFF             *
  *                 --+--                                                            -DIP-SW.CONFIG             *
  *                   |                                                                S1=OFF,S2=ON             *
  *                   |             																		    *
  *                   |                                                          --------------------			*
  *             ------+------           Trig Signal CH1-CH8 (Active'0')         |                    |          *
  *            |       P0.16 |--------------------------------------------------|CH1                 |          *
  *            |         .   |                                                  | .                  |          *
  *            |         .   |                                                  | .                  |          *
  *            |         .   |                                                  | .                  |          *
  *            |       P0.23 |--------------------------------------------------|CH8                 |          *
  *            |             |                                                  |                    |          *
  *            |             |                                                  |   ET-REMOTE MP3V2  |          *
  *            |             |          Trig Signal CH9-CH16 (Active'0')        |                    |          *
  *            |       P1.16 |--------------------------------------------------|CH9                 |          *
  *            |         .   |                                                  | .                  |          *
  *      +-----|P0.30    .   |                                                  | .                  |          *
  *      |     |         .   |                                                  | .                  |          *
  *      |     |       P1.23 |--------------------------------------------------|CH16       [Supply] |          *
  *      |      -----+-------                                                   |   EOF      G    5V |          *
  *      |           |LPC2138                                                    ----+-------+-----+-           *
  *      |         --+--                                                             |       |     |            *
  *      |          ---                                                              |       |     |            *
  *      |           -                                                               |       |     +-->5V       *
  *      +---------------------------------------------------------------------------+     --+--                *
  *                                                                                         ---                 *
  *                                                                                          -                  *
  * Operation       : Play File 1-16 By Trig Auto                                                               *
  * Last Update     : 7/June/2012                                                                               *   
  * Create By       : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                                      *
  *                                                                                                             * 
  *                                                                                                             *
  ***************************************************************************************************************/ 
  
  
  
#include "LPC213x.h" 	                             
#include "stdio.h"


unsigned long counter ; 

/**************************************************************  
 *        Interrupt Service routeen Timer0 For Delay(ms) 	  *
 *               (Interrupt every 1 ms) 					  *
 **************************************************************/ 

 void TM0_CNT (void) __irq
   {
     counter = counter+1  ;     //Increment Counter 
     T0IR        = 1      ;     // Clear interrupt flag  
	 
     VICVectAddr = 0      ;     // Acknowledge Interrupt 
  }

/****************************************************************************
 *                 Initial Timer0 Control for delay                      	*
 *                                                                          *
 *   -Timer Counter 0 Interrupt executes each 1ms @ 58.9824 MHz CPU Clock   *
 ****************************************************************************/

 void Timer0_Init(void)
  {
   T0MR0        = 29491                   ;    //counts = 1 ms/pclk = 1 ms/33.9084201ns=29491.2
   T0MCR        = 3                       ;    //Interrupt and Reset on MR0
   VICVectAddr0 = (unsigned long) TM0_CNT ;    //set interrupt vector in 1
   VICVectCntl0 = 0x20 | 4                ;    //use it for Enable Vector IRQ Slot Timer0 
   VICIntEnable = 0x00000010              ;    //Enable Timer0 Interrupt Request to update Priority hardware
  }

 

/***************************************************
 *                   Function delay ms 			   *
 ***************************************************/

void delay_ms(unsigned long ms)
 {
  counter = 0              ;   //clear counter
  T0TCR   = 1              ;  // Timer0 Enable
 
  while(counter != ms){;}
  T0TCR   = 0              ;  // Timer0 Disable
 }



 /***********************************************************
 **                     Initial Port                      **
 ***********************************************************/
 
 void Init_Port(void)
  {
  //------ Set GPIO  PIN -------

  PINSEL1 = 0x00000000               ;     //Set Port0-PIN[16..31]= GPIO 
  PINSEL2 = 0x00000000               ;     //Set Port1-PIN[16..31]= GPIO 


 //------ Set Direction of GPIO PIN -------

   IODIR0  = 0xBFFFFFFF              ;	   //Set P0.[0..29,31] = Output ,P0.30 = Input
   IODIR1  = 0xFFFFFFFF              ;	   //Set P1.[0..31] = Output
 
 //--------- Default Value P0,P1 ---------

  IOPIN0  = 0xFFFF0000              ;     //Set Data P0.[16...31] = 1
  IOPIN1  = 0xFFFF0000              ;     //Set Data P1.[16...31] = 1
 
  } 



 
/************************************************************************
 *               Check Status Signal EOF : End OF File 				    *
 ************************************************************************/

void Chk_Eof(void)
{
  unsigned long eof ;
       
  do                                     //Loop Check Eof = 0 :end file 
   {
     eof  =  IOPIN0                    ; //Read P0.30 : 0 = end of message , 1 = Ready for Play or Playing  
     eof  = eof & 0x40000000           ; //Mark bit 30
   }while(eof ==  0x40000000)          ; //eof = 0 exit loop
    
  do                                     //Loop Check Eof = 1 : Ready 
   {
     eof  = IOPIN0                    ; //Read P0.30 : 0 = end of message , 1 = Ready for Play or Playing  
     eof  = eof & 0x40000000          ; //Mark bit 30
   }while(eof == 0)                   ; //eof = 1 exit loop
}



 /************************************************************
  **                                                        **
  **      Function Play File CH1-CH16(Trig Active 0)        **
  **                                                        **
  ************************************************************/ 


void Play_File(void)
{
  
  char bt ;
  long bi = 0x00010000 ;

    //--------------- P0[16..23] TRIG CH[1..8]-------------

  for(bt=0;bt<8;bt++)               //Loop Control Port bit for Trig Next File
   {                    
     IOCLR0  = bi             ;    //P0_Bit(x)=0 : Trig-CH(x-15) : x-start 16   
     delay_ms(20)             ;    //Delay 20 ms for Trig 0
     IOSET0  = bi             ;    //P0_Bit(x)=1   : x-start 16 
     Chk_Eof()                ;    //Check Play End File
   
     bi= bi << 1              ;    //Value for next Mark bit 
  
   }

    //--------------- P1[16..232] TRIG CH[9..16]-------------

  bi  = 0x00010000            ;    //Initial Start Mark bit16 

  for(bt=0;bt<8;bt++)              //Loop Control Port bit for Trig Next File
   {                   
     IOCLR1  = bi             ;    //P1_Bit(x)=0 : Trig-CH(x-15) : x-start 16   
     delay_ms(20)             ;    //Delay 20 ms for Trig 0
     IOSET1  = bi             ;    //P1_Bit(x)=1   : x-start 16 
     Chk_Eof()                ;    //Check Play End File
   
     bi= bi << 1              ;    //Value for next Mark bit 
  
         
   }

}



/**********************************************************************
 **                                                                  **
 **                         main Program                             **
 **                                                                  **
 **********************************************************************/
 
 int main(void) 
 {

   Init_Port()        ;
   Timer0_Init()      ;

   delay_ms(3000)     ;   //delay for Sync Borad MP3 Ready 

   while(1)
    {
      delay_ms(500)   ;
      Play_File()     ;   //Sen Signal Trig Start Play File CH1  
    }   
}


